/*******************************************************************************************************
 *                                                                                                     *
 *        **********                                                                                   *
 *       ************                                                                                  *
 *      ***        ***                                                                                 *
 *      ***   +++   ***                                                                                *
 *      ***   + +   ***                                                                                *
 *      ***   +                        CHIPCON HARDWARE ABSTRACTION LIBRARY FOR THE CC2420             *
 *      ***   + +   ***                      CC2420 crystal oscillator stabilization                   *
 *      ***   +++   ***                                                                                *
 *      ***        ***                                                                                 *
 *       ************                                                                                  *
 *        **********                                                                                   *
 *                                                                                                     *
 *******************************************************************************************************
 * The Chipcon Hardware Abstraction Library is a collection of functions, macros and constants, which  *
 * can be used to ease access to the hardware on the CC2420 and the target microcontroller.            *
 *                                                                                                     *
 * This file contains a function that ensures that the CC2420 crystal oscillator is stable.            *
 *                                                                                                     *
 * EXAMPLE OF USAGE:                                                                                   *
 *     // Turn the crystal oscillator on and wait for it to become stable                              *
 *     DISBALE_GLOBAL_INT();                                                                           *
 *     FASTSPI_STROBE(CC2420_SXOSCON);                                                                 *
 *     ENABLE_GLOBAL_INT();                                                                            *
 *     halRfWaitForCrystalOscillator();                                                                *
 *******************************************************************************************************
 * Compiler: AVR-GCC                                                                                   *
 * Target platform: CC2420DB, CC2420 + any MCU with very few modifications required                    *
 *******************************************************************************************************
 * Revision history:                                                                                   *
 * $Log: hal_rf_wait_for_crystal_oscillator.c,v $
 * Revision 1.3  2004/03/30 14:59:35  mbr
 * Release for web
 * 
 *
 *
 *******************************************************************************************************/
#include "include/include.h"




//-------------------------------------------------------------------------------------------------------
//	void rfWaitForCrystalOscillator(void)
//
//	DESCRIPTION:
//		Waits for the crystal oscillator to become stable. The flag is polled via the SPI status byte.
//      
//      Note that this function will lock up if the SXOSCON command strobe has not been given before the
//      function call. Also note that global interrupts will always be enabled when this function 
//      returns.
//-------------------------------------------------------------------------------------------------------
void halRfWaitForCrystalOscillator(void) {
    BYTE spiStatusByte;

    // Poll the SPI status byte until the crystal oscillator is stable
    do {
	    DISABLE_GLOBAL_INT();
	    FASTSPI_UPD_STATUS(spiStatusByte);
	    ENABLE_GLOBAL_INT();
    } while (!(spiStatusByte & (BM(CC2420_XOSC16M_STABLE))));

} // halRfWaitForCrystalOscillator

